<?php
$posts_per_page = $settings['query_posts_per_page'];
$post_categories = $settings['query_post_categories'];
$post_tags = $settings['query_post_tags'];
$show_thumbnail = $settings['layout_show_thumbnail'];
$show_category = $settings['layout_show_category'];
$number_of_categories = $settings['layout_number_of_categories'];
$show_date = $settings['layout_show_date'];
$orderby = $settings['query_orderby'];
$order = $settings['query_order'];
$post_title_crop = isset($settings['layout_post_title_crop']) ? $settings['layout_post_title_crop']['size'] : '35';
$show_author = $settings['layout_show_author'];
$show_view_count = $settings['layout_show_view_count'];
$show_read_time = $settings['layout_show_read_time'];
$show_readmore = $settings['layout_show_read_more_link'];
$readmore_text = $settings['layout_read_more_text'];
$read_more_icon = $settings['layout_read_more_icon'];
$show_review_rating = $settings['layout_show_review_rating'];
$show_content = $settings['layout_show_content'];
$post_content_crop = isset($settings['layout_post_content_crop']) ? $settings['layout_post_content_crop']['size'] : '20';
$post_format = $settings['query_post_format'];
$category_position = $settings['layout_category_position'];
$layout_thumbnail_img_size = $settings['layout_thumbnail_img_size_size'];
$thumbnail_image_aspect_ratio = isset($settings['layout_thumbnail_image_aspect_ratio']['size']) ? $settings['layout_thumbnail_image_aspect_ratio']['size'] : 'large';
$video_icon = 'no';
$category_style = $settings['layout_category_style'];

$desktop_column_number = (isset($settings['layout_column_number'])) ? $settings['layout_column_number'] : 3;
$tablet_column_number = (isset($settings['layout_column_number_tablet'])) ? $settings['layout_column_number_tablet'] : 2;
$mobile_column_number = (isset($settings['layout_column_number_mobile'])) ? $settings['layout_column_number_mobile'] : 1;

$column_desktop = round(12 / (int)$desktop_column_number);
$column_tablet = round(12 / (int)$tablet_column_number);
$column_mobile = round(12 / (int)$mobile_column_number);


$args = array(
    'posts_per_page' => $posts_per_page,
    'orderby' => $orderby,
    'order' => $order
);

if (!empty($post_categories)) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'category',
            'terms' => $post_categories,
            'field' => 'id'
        ),
    );
}

if (!empty($post_tags)) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'post_tag',
            'terms' => $post_tags,
            'field' => 'id'
        ),
    );
}

if (in_array('video', $post_format) && !in_array('standard', $post_format)) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'post_format',
            'field' => 'slug',
            'terms' => array('post-format-video'),
            'operator' => 'IN'
        )
    );
}

if ($settings['query_enable_offset'] == 'yes') {
    $args['offset'] = $settings['query_offset_item_num'];
}

$query = get_posts($args);

$style_class = $settings['layout_layout_style'];

$show_review_rating_style2 = 'no';
$show_review_rating_style1 = 'no';
if ($show_review_rating == 'yes') {
    $review_style = $settings['layout_review_style'];
    if ($review_style == 'style2') {
        $show_review_rating_style2 = 'yes';
    } else {
        $show_review_rating_style1 = 'yes';
    }
}
?>
<?php if ($query) { ?>

    <div class="qoxag-wrapper qoxag-post-masonary">
        <div class="ts-masonary ts-gutter-30px">
            <?php
            foreach ($query as $post) {
            ?>
                <div class="ts-masonary-item">
                    <?php
                    $postid = $post->ID;
                    if (get_post_format($postid) == 'quote') {
                        include QOXAG_CORE . "/elementor/content-parts/content-quote.php";
                    } else {
                        include QOXAG_CORE . "/elementor/content-parts/content-1.php";
                    }
                    ?>
                </div>
            <?php
            }
            ?>
        </div>
        <!-- content will be here -->
    </div>
<?php } ?>